CON
_CLKMODE     = XTAL1 + PLL16X
_XINFREQ     = 5_000_000


'Signaldefinitionen
'signaldefinition regnatix
#0,     D0,D1,D2,D3,D4,D5,D6,D7                         'datenbus
#8,     A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10               'adressbus
#19,    REG_RAM1,REG_RAM2                               'selektionssignale rambank 1 und 2
#21,    REG_PROP1,REG_PROP2                             'selektionssignale für administra und bellatrix
#23,    REG_AL                                          'strobesignal für adresslatch
#24,    REG_PROP3                                       'Venatrix-Chipselect Signal
        BUSCLK                                          'bustakt
        BUS_WR                                          '/wr - schreibsignal
        BUS_HS '                                        '/hs - quittungssignal

CON 'Sonstiges
'CNT_HBEAT       = 5_000_0000                            'blinkgeschw. front-led
DB_IN           = %00000111_11111111_11111111_00000000  'maske: dbus-eingabe
DB_OUT          = %00000111_11111111_11111111_11111111  'maske: dbus-ausgabe



obj
    ios :"reg-ios-64"
    'DEBUG:"serialMirror"

dat defbel byte "Jetpac.bel",0
    defadm byte "Jetpac.adm",0
OBJ '' R E G N A T I X

CON ''------------------------------------------------- BUS
'prop 1  - administra   (bus_putchar1, bus_getchar1)
'prop 2  - bellatrix    (bus_putchar2, bus_getchar2)
'prop 3  - venatrix     (bus_putchar3, bus_getchar3)
pub main|cmd,i,a,b
  bus_init                                              'bus initialisieren
  repeat

    cmd := ios.bus_getchar2                                  'kommandocode von Bella empfangen
'    debug.dec(cmd)
'    i++
'    if i==30
'       debug.tx(13)
'       i:=0
'    else
'       debug.tx(32)
'    if cmd<61
     case cmd
        223  : Joystick_abfrage
        other:
                  ios.bus_putchar1(cmd)

PUB bus_init |marker                                           'bus: initialisiert bussystem
{{bus_init - bus: initialisierung aller bussignale }}
  outa[bus_wr]    := 1          ' schreiben inaktiv
  outa[reg_ram1]  := 1          ' ram1 inaktiv
  outa[reg_ram2]  := 1          ' ram2 inaktiv
  outa[reg_prop1] := 1          ' prop1 inaktiv
  outa[reg_prop2] := 1          ' prop2 inaktiv
  outa[reg_prop3] := 1          ' prop3 inaktiv ->Venatrix
  outa[busclk]    := 0          ' busclk startwert
  outa[reg_al]    := 0          ' strobe aus
  dira := db_in                 ' datenbus auf eingabe schalten
  outa[18..8]     := 0          ' adresse a0..a10 auf 0 setzen
  outa[23]        := 1          ' obere adresse in adresslatch übernehmen
  outa[23]        := 0

  marker:= get_dirmarker                 'usermarker von administra holen
  ios.belload(@defbel)
  activate_dirmarker(marker)             'usermarker wieder in administra setzen

  ios.admload(@defadm)                   'wird nach dem booten wieder in das Userverzeichnis gesprungen)

  activate_dirmarker(marker)             'usermarker wieder in administra setzen

'  debug.start(31,30,0,19200)

PRI Joystick_Abfrage|a,b,c
    a:=ios.bus_getchar2            'Joysticknummer
    b:=ios.bus_getchar2            'Board (Sepia oder Venatrix)
    ios.bus_putchar2(ios.Joystick(b,a))

PRI activate_dirmarker(mark)                       'USER-Marker setzen

     ios.sddmput(ios#DM_USER,mark)                  'usermarker wieder in administra setzen
     ios.sddmact(ios#DM_USER)                       'u-marker aktivieren

PRI get_dirmarker:dm                                'USER-Marker lesen

    ios.sddmset(ios#DM_USER)
    dm:=ios.sddmget(ios#DM_USER)
